#include <iostream>
#include <vector>

using namespace std;

void makeatree(int l, int r, int n, vector<vector<int>> &tree, vector<char> &s){
    if (l==r){
        int a=s[l]-'a';
        tree[n][a]++;
    }
    else{
        int mid=(l+r)/2;
        makeatree(l, mid, 2*n+1, tree, s);
        makeatree(mid+1, r, 2*n+2, tree, s);
        for (int i=0; i<5; i++){
            tree[n][i]=tree[2*n+1][i]+tree[2*n+2][i];
        }
    }
}

void update(int l, int r, int n, vector<vector<int>> &tree, vector<char> &s, int x, char a, char b){
    int a1=a-'a';
    int b1=b-'a';
    if (x>0){
        if (l==r){
            tree[n][a1]--;
            tree[n][b1]++;
            s[l]=b;
        }
        else{
            int mid=(l+r)/2;
            if (x>tree[2*n+1][a1]){
                update(mid+1, r, 2*n+2, tree, s, x-tree[2*n+1][a1], a, b);
            }
            update(l, mid, 2*n+1, tree, s, min(x, tree[2*n+1][a1]), a, b);
            for (int j=0; j<5; j++){
                tree[n][j]=tree[2*n+1][j]+tree[2*n+2][j];
            }
        }
    }
}

int main(){
    int n,m;
    cin>>n>>m;
    vector<char> s(n);
    for (int i=0; i<n; i++){
        cin>>s[i];
    }
    vector<vector<int>> tree(4*n, vector<int> (5, 0));
    makeatree(0, n-1, 0, tree, s);
    int x;
    char a,b;
    for (int i=0; i<m; i++){
        cin>>x>>a>>b;
        update(0, n-1, 0, tree, s, x, a, b);
    }
    for (int j=0; j<n; j++){
        cout<<s[j];
    }
}